/*
 * global.h
 *
 * Created 8/1/2009 By Johnny Huynh
 *
 * Version 00.00.01 8/1/2009
 *
 * Copyright Information:
 * All content copyright  2009 Johnny Huynh. All rights reserved.
 */
 
 #ifndef GLOBAL_H
 #define GLOBAL_H
 
 namespace global {}
 
 #include "macro.h"
 #include "pnotify.h"
 
 /**
  * Turn debugging off to optimize the program
  */
 //#ifndef NDEBUG
 //#define NDEBUG
 //#endif // NDEBUG
 
 /**
  * The primary numerical type used in this program
  */
 #ifndef PRIMARY_TYPE
 #define PRIMARY_TYPE float
 #endif // PRIMARY_TYPE
 
 /**
  * The type of the 2D vector used in this program
  */
 #define VECTOR2_TYPE LVector2f
 
 /**
  * The type of the 3D vector used in this program
  */
 #define VECTOR3_TYPE LVector3f
 
 #ifndef PI
 #define PI 3.14159f
 #endif // PI
 
 /**
  * The minimum camera height above the player's character
  */
 #ifndef CAMERA_HEIGHT
 #define CAMERA_HEIGHT 5.0f //10.0f//5.0f
 #endif // CAMERA_HEIGHT
 
 /**
  * The distance the camera is away from the player's character (or players' characters)
  * in the x and y direction (i.e. the direction on the plane of the terrain)
  */
 #ifndef CAMERA_XY_DISTANCE
 #define CAMERA_XY_DISTANCE 25.0f //50.0f//25.0f
 #endif // CAMERA_XY_DISTANCE
 
 /**
  * The base frame-per-second (FPS) used to calculate the FPS ratio to advance the World by
  * based on the current FPS
  */
 #ifndef BASE_FPS
 #define BASE_FPS 60.0f
 #endif // BASE_FPS
 
 /**
  * Ratio used to slowly readjust the view to be behind the controlled character
  * This value should be a positive number (i.e. non-zero and non-negative)
  */
 #ifndef THIRD_PERSON_VIEW_READJUSTMENT_RATIO
 #define THIRD_PERSON_VIEW_READJUSTMENT_RATIO (1.0f/75.0f)
 #endif // THIRD_PERSON_VIEW_READJUSTMENT_RATIO
 
 /**
  * The minimum degrees used to readjust the view to be behind the controlled character
  * This value must be a non-negative number
  */
 #ifndef THIRD_PERSON_VIEW_MIN_READJUSTMENT
 #define THIRD_PERSON_VIEW_MIN_READJUSTMENT 0.5f
 #endif // THIRD_PERSON_VIEW_MIN_READJUSTMENT
 
 #ifndef EXIT_PROGRAM
 #define EXIT_PROGRAM PandaFramework::event_esc( NULL, static_cast<void*>( &global::_framework ) )
 #endif // EXIT_PROGRAM
 
 #ifndef EXIT_PROGRAM_WITH_ERROR
 #define EXIT_PROGRAM_WITH_ERROR exit( 1 )
 #endif // EXIT_PROGRAM_WITH_ERROR
 
 #include "pandaFramework.h"
 #include "pandaSystem.h"
 
 #include "genericAsyncTask.h"
 #include "asyncTaskManager.h"
 
 #include "executionEnvironment.h"
 
 #include "Ralph.h"
 #include "World.h"
 #include "InputConfig.h" // perhaps change to InputHandler?
 
 namespace global
 {
     PandaFramework _framework;
     // The global task manager
     PT(AsyncTaskManager) _task_mgr_Ptr( new AsyncTaskManager( "Main" ) );//AsyncTaskManager::get_global_ptr() );
     PT(AsyncTaskManager) _action_task_mgr_Ptr( new AsyncTaskManager( "Action" ) );
     // The global clock
     PT(ClockObject) _clock_Ptr( ClockObject::get_global_clock() );
     // Full path of executable file directory (Panda3D's filename convention; Unix style)
     std::string _file_dir( Filename(ExecutionEnvironment::get_binary_name()).get_dirname() );
     // The World
     World<PRIMARY_TYPE>* _world_Ptr;
     // Pointer to _player_1's character
     //PT(Ralph<PRIMARY_TYPE>) _player_1_Ptr;
     // Pointer to the InputConfig that handles inputs for Player 1
     PT(InputConfig<PRIMARY_TYPE>) _player_1_handler_Ptr;
 }
 
 #endif // GLOBAL_H